<?php

namespace App\Livewire\Forms\Account;

use App\Models\Coin;
use Livewire\Attributes\Validate;
use Livewire\Form;

class SendForm extends Form
{
    public Coin $coin;
    public string $via;
    public $receiver;

    #[Validate('required|numeric|gt:0')]
    public $amount;
    
    public function init(Coin $coin, $via) {
        $this->coin = $coin;
        $this->via = $via;
    }
    public function messages() {
        
        return [
            'receiver.min' => "Invalid {$this->coin->symbol} address.",
            'receiver.max' => "Invalid {$this->coin->symbol} address.",
        ];
    }

    public function rules() {
        return [
            'receiver' => $this->via=='coin' ? 'required|string|min:26|max:42': 'required|string',
        ];
    }
}
