<?php

namespace App\Livewire\Forms\Account;

use Livewire\Form;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rules\Password;

class ProfileForm extends Form
{
    #[Validate('required|digits:4')]
    public $pin;

    #[Validate('required')]
    public $current_password;

    public $new_password;
    public $new_password_confirmation;

    public function rules() {
        return [
            'new_password' => ['required', 'confirmed', Password::min(8)->symbols()->numbers()->letters()->mixedCase()]
        ];
    }
}
