<?php

namespace App\Livewire\Auth;

use App\Livewire\Forms\Auth\SignupForm;
use App\Models\User;
use App\Notifications\User\Welcome;
use App\Utils\ManagesOTP;
use App\Utils\ManagesSecretPhrase;
use Livewire\Component;

class Signup extends Component
{
    use ManagesOTP, ManagesSecretPhrase;
    
    public SignupForm $form;

    public function render() {
        return view('livewire.auth.signup')->layout('components.layouts.auth', [
            'title' => 'Create Account'
        ]);
    }

    public function mount() {
        $this->form->secret_phrase = $this->generateSecretPhrase();
        $this->form->pay_id = 'T'.random_int(100000, 999999);
    }

    public function signup() {
        $this->validate();

        $details = $this->form->all();
        
        $user = User::create($details);
        
        auth()->loginUsingId($user->id, true);

        $otp = $this->createOTP($user, 'email_verification');
        $user->notify(new Welcome($otp->code));

        return to_route('email.verify');
    }
}
