<?php

namespace App\Livewire\Auth;

use App\Models\User;
use App\Utils\ManagesSecretPhrase;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('components.layouts.auth', [
    'title' => 'Secret Phrase'
])]
class SecretPhrase extends Component
{
    use ManagesSecretPhrase;

    public $secret_phrase;

    public function mount() {
        $user = auth()->user();
        $this->secret_phrase = $this->secretPhraseList($user->secret_phrase);
    }

    public function verify() {
        $this->dispatchAlert(
            text: 'Backed up secret phrase successfully.',
            type:'success',
        );
        
        $user = User::find(auth()->id());
        $user->markSecretPhraseAsBackedUp();

        return $this->redirect(route('account.set-pin'), true);
    }
}
