<?php

namespace App\Livewire\Auth;

use Livewire\Attributes\Validate;
use Livewire\Component;

class Login extends Component
{
    #[Validate('required|string|max:255')]
    public $email;

    #[Validate('required')]
    public $password;

    public function render() {
        return view('livewire.auth.login')->layout('components.layouts.auth', [
            'title' => 'Login'
        ]);
    }

    public function login() {
    
        $this->validate();

        $credentials = $this->all();

        if(auth()->attempt($credentials, true)) {
            return $this->redirect(route('account.enter-pin'), true);
        }
        
        return $this->dispatchAlert(text: 'Invalid login details.');
    }
}
