<?php

namespace App\Livewire\Auth;

use App\Models\User;
use App\Notifications\User\PasswordReset;
use App\Rules\TwelveWords;
use App\Utils\ManagesSecretPhrase;
use Livewire\Attributes\Validate;
use Livewire\Component;

class ForgotPassword extends Component
{
    use ManagesSecretPhrase;

    #[Validate('required|email|string')]
    public $email;

    #[Validate(['required', 'string', new TwelveWords])]
    public $secret_phrase;

    public function render() {
        return view('livewire.auth.forgot-password')->layout('components.layouts.auth', [
            'title' => 'Forgot Password'
        ]);
    }

    public function recover() {
        $this->validate();

        $user = User::where('email', $this->email)->first();

        if($user === null) {
            return $this->dispatchAlert('Invalid Email Address.');
        }

        if($this->secretPhraseIsIncorrect($this->secret_phrase, $user)) {
            return $this->dispatchAlert('Check your 12 word seed phrase correctly and try again.');
        }

        $password = random_int(10000000, 99999999);

        $user->update([
            'password' => $password
        ]);

        $user->notify(new PasswordReset($password));
        $this->dispatchAlert('Password sent. If your email and your 12 word seed phrase are correct, check your inbox or spam folder for your new password', 'info');
        $this->reset();
    }
}
