<?php

namespace App\Livewire\Account;

use App\Livewire\Forms\Account\ProfileForm;
use App\Utils\HandlesProfile;
use Livewire\Component;

class Profile extends Component
{
    use HandlesProfile;

    public ProfileForm $form;

    public function render() {
        return view('livewire.account.profile')->layout('components.layouts.account-inner', [
            'title' => 'Security Settings',
            'subtitle' => 'Change or edit your password.',
        ]);
    }

    public function update() {
        $this->validate();

        if($this->pinIsIncorrect()) {
            return $this->dispatchAlert('Your four digit passcode is incorrect.');
        }

        if($this->currentPasswordIsIncorrect()) {
            return $this->dispatchAlert('Your old password is not correct.');
        }

        if($this->currentPasswordIsSameAsNew()) {
            return $this->dispatchAlert('Your new password can not be the same as your current one.');
        }

        $user = auth_user();
        $user->update([
            'password' => $this->form->new_password,
        ]);

        $this->dispatchAlert('Password changed.', 'success');
        return $this->redirect(route('account.settings'), true);
    }
}
