<?php

namespace App\Livewire\Account;

use Illuminate\Notifications\DatabaseNotification;
use Livewire\Component;

class Notifications extends Component
{
    public function render() {
        $user = auth_user();
        return view('livewire.account.notifications', [
            'notifications' => $user->notifications
        ])->layout('components.layouts.account-inner', ['title' => 'Notifications']);
    }

    public function delete($notification_id) {
        $notification = DatabaseNotification::find($notification_id);
        $notification->delete();
        $this->dispatchAlert('Notification deleted.', 'notice');
    }
}
