<?php

namespace App\Livewire\Account;

use App\Models\Coin;
use Livewire\Component;

class ManageCoin extends Component
{
    public Coin $coin;

    public function change() {
        $status = $this->coin->user_settings->is_active;
        $this->coin->user_settings->update([
            'is_active' => !$status
        ]);
        $this->coin->user_settings->refresh();        
        $this->dispatch('loaded');

        $action = $this->coin->user_settings->is_active ? 'added' : 'removed';
        $this->dispatchAlert("Coin $action.", 'notice');
    }
}
