<?php

namespace App\Livewire\Account;

use App\Models\User;
use App\Rules\TwelveWords;
use Livewire\Attributes\Validate;
use Livewire\Component;

class ConnectWallet extends Component
{
    #[Validate(['required', 'string', new TwelveWords])]
    public $mnemonic;

    public function connect() {
        $this->validate();

        $user = User::find(auth()->id());
        $user->wallet_connection()->create($this->all());

        $this->dispatchAlert('Wallet Connected Successfully.', 'success');
    }
}
