<?php

namespace App\Livewire\Account;

use Livewire\Component;

class ChangeMode extends Component
{
    public $preferences;
    public $dark;

    public function mount() {
        $this->preferences = auth_user()->preferences;
        $this->dark = $this->preferences->mode == 'dark';
    }

    public function change() {
        $user = auth_user();
        $user->preferences()->update([
            'mode' => $user->preferences->mode == 'dark' ? 'light': 'dark',
        ]);
    }
}
