<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Redirect;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Contracts\Auth\MustBackUpSecretPhrase;

class RedirectIfSecretPhaseHasBeenBackedUp {
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response 
    {
        if($request->user() && $request->user() instanceof MustBackUpSecretPhrase && $request->user()->hasBackedUpSecretPhrase()) {
            return to_route('account');
        }

        return $next($request);
    }
}
