<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Contracts\Auth\MustBackUpSecretPhrase;

class EnsureSecretPhraseIsBackedUp
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        if (! $request->user() ||
            ($request->user() instanceof MustBackUpSecretPhrase &&
            ! $request->user()->hasBackedUpSecretPhrase())) {
            return $request->expectsJson()
                    ? abort(403, 'Your secret phrase is not backed up.')
                    : Redirect::guest(URL::route('secret-phrase.backup'));
        }

        return $next($request);
    }
}
