<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use Filament\Tables\Actions\Action;
use App\Http\Controllers\Controller;
use App\Models\Coin;
use Filament\Notifications\Notification;

class UserSettingsController extends Controller {
    /**
     * Handle the incoming request.
     */
    public static function update(
        array $data,
        User $user,
    ) {
        $coin_id = $data['coin_id'];
        $coin = Coin::find($coin_id);
        $networkCoinSettings = $coin->network_coin->settings()->where('user_id', $user->id)->first();
        
        $networkCoinSettings->update([
            $data['fee'] => $data['value'],
        ]);

        Notification::make()
            ->success()
            ->title('User settings updated successfully.')
            ->send();
    }

    public static function updateSettings(
        array $data,
        User $user,
    ) {
        $coin_id = $data['coin_id'];
        $userSettings = $user->settings()->where('coin_id', $coin_id)->first();

        $userSettings->update([
            'allow_payid_send' => $data['allow_payid_send'],
            'allow_send' => $data['allow_send'],
            'allow_swap' => $data['allow_swap'],
            'is_active' => $data['is_active'],
        ]);

        $userSettings->update($data);

        Notification::make()
            ->success()
            ->title('User settings updated successfully.')
            ->send();
    }
}
