<?php

namespace App\Http\Controllers\Admin;

use App\Models\Coin;
use App\Models\User;
use App\Utils\ProcessesFees;
use App\Utils\ConvertsAmount;
use Filament\Tables\Actions\Action;
use App\Http\Controllers\Controller;
use App\Utils\CreatesTransaction;
use Filament\Notifications\Notification;

class UserController extends Controller {

    public static function updateBalance(
        array $data,
        User $user,
        Action $action,
    ) {
        $balance = $user->balances()->where('coin_id', $data['coin_id'])->first();
        $coin = Coin::find($data['coin_id']);
        $direction = $data['action'];

        $transaction = new CreatesTransaction;
        $transaction->init($coin, $user, $data['amount']);

        switch ($direction) {

            case 'debit':
                static::debitAmountIsGreaterThanBalance($data['amount'], $balance, $action);
                $balance->decrement('value', $data['amount']);
                Notification::make()
                    ->title('Debit processed successfully.')
                    ->success()
                    ->send();
                $transaction->createDebitTransaction();
                break;

            case 'credit':
                $balance->increment('value', $data['amount']);
                $transaction->createCreditTransaction();
                Notification::make()
                    ->title('Topup processed successfully.')
                    ->success()
                    ->send();
                break;
                    
            default:
                return Notification::make()
                    ->title('Something went wrong.')
                    ->danger()
                    ->send();
                    $action->halt();
                break;
        }
    }

    private static function debitAmountIsGreaterThanBalance($amount, $balance, $action) {
        if ($amount > $balance->value) {
            Notification::make()
                ->title('Amount to be debited can not be greater than account balance.')
                ->danger()
                ->send();
            $action->halt();
        }
    }
}
