<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use App\Livewire\Coin\Swap;
use App\Models\Coin;

class SearchController extends Controller {
    public function index(string $action = 'search') {
        return view('account.coin.list', [
            'coins' => Coin::active()->get(),
            'action' => $action,
            'route' => fn($coin) => route("coin.$action", [
                'coin' => $coin->uuid,
                'via' => request('via')
            ]),
        ]);
    }

    public function search(string $action = 'search') {
        switch ($action) {
            case 'search':
                $title = 'Search Crypto';
                break;

            case 'address':
                $title = 'Your Wallet Addresses';
                break;

            case 'manage':
                $title = 'Manage Crypto';
                break;

            case 'receive':
                $title = 'Receive Crypto';
                break;

            default:
                $title = 'Manage Crypto';
                break;
        }

        return view('account.coin.search', [
            'coins' => Coin::all()->sortByDesc(function ($coin) {
                return $coin->user_settings->is_active;
            }),
            'action' => $action,
            'route' => fn($coin) => route("coin.view", $coin->uuid),
            'title' => $title,
        ]);
    }
}
