<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use App\Models\Coin;
use App\Utils\ConvertsAmount;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    use ConvertsAmount;

    public function index() {
        $user = $this->user;
        $coins = Coin::active()->get()->sortByDesc(function($coin) {
            return $this->amountInFiat($coin->user_balance->value, $coin);
        });
        $preferences = $this->preferences;
        
        return view('account.home', compact('user', 'coins', 'preferences'));
    }

    public function preferences(Request $request) {
        $this->user->preferences()->update($request->all());
        return response()->json($this->preferences);
    }
}
