<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use App\Models\Coin;

class CoinController extends Controller
{
    public function index(Coin $coin) {
        return view('account.coin.index', compact('coin'));
    }

    public function receive(Coin $coin, $via = 'coin') {
        $user = $this->user;

        return $via == 'coin'
        ? view('account.receive.coin', compact('coin', 'user'))
        : view('account.receive.payid', compact('coin', 'user'));
    }
}
