<?php

namespace App\Filament\Widgets;

use App\Models\Transaction;
use Filament\Widgets\ChartWidget;

class TransactionsChart extends ChartWidget
{
    protected static ?string $heading = 'Transactions Per Day';
    protected static ?int $sort = 3;

    protected function getData(): array
    {
        return [
            'datasets' => [
                [
                    'label' => 'Transactions Per Day',
                    'data' => Transaction::perDay(),
                    'backgroundColor' => '#36A2EB',
                    'borderColor' => '#9BD0F5',
                ]
            ]
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
