<?php

namespace App\Filament\Widgets;

use App\Models\Coin;
use App\Models\Investment;
use App\Models\Plan;
use App\Models\Transaction;
use App\Models\User;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;


class AdminStatsOverview extends BaseWidget 
{
    protected static ?int $sort = 1;


    protected function getStats(): array {
        return [
            Stat::make('Total Users', User::where('is_admin', false)->count())
                ->description('All Database Users')
                ->descriptionIcon('heroicon-m-users')
                ->descriptionColor('success')
                ->chart(User::registrationsPerDay())
                ->chartColor('success'),

            Stat::make('Total Plans', Plan::count())
                ->description('All investment plans in the system')
                ->descriptionIcon('heroicon-m-chart-bar-square')
                ->descriptionColor('primary'),
            Stat::make('Total Investments', Investment::count())
                ->description('All Investment made by users.')
                ->descriptionIcon('heroicon-m-chart-bar')
                ->descriptionColor('blue'),
            Stat::make('Active Investments', Investment::where('is_active', true)->count()),
            Stat::make('Inctive Investments', Investment::where('is_active', false)->count()),
            Stat::make('Total Coins', Coin::where('is_active', true)->count()),
            Stat::make('Inactive Coins', Coin::where('is_active', false)->count()),
            Stat::make('Pending Transactions', Transaction::where('status', 'pending')->count()),
            Stat::make('Completed Transactions', Transaction::where('status', 'completed')->count()),
        ];
    }
}
