<?php

namespace App\Filament\Resources;

use App\Filament\Resources\VerificationResource\Pages;
use App\Filament\Resources\VerificationResource\RelationManagers;
use App\Models\Verification;
use Filament\Forms;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\HtmlString;

class VerificationResource extends Resource {
    protected static ?string $model = Verification::class;

    protected static ?string $navigationIcon = 'heroicon-o-check-badge';

    public static ?string $navigationGroup = 'User Management';

    protected static ?int $navigationSort = 6;

    public static function form(Form $form): Form {
        return $form
            ->schema([
                Forms\Components\Select::make('user_id')
                    ->relationship('user', 'email')
                    ->required()
                    ->columnSpanFull(),
                Section::make('Documents')->schema([
                    Placeholder::make('id_front')
                        ->content(function ($record): HtmlString {
                            return new HtmlString("<img src= '/uploads/" . $record->id_front . "')>");
                        }),
                    Placeholder::make('id_back')
                        ->content(function ($record): HtmlString {
                            return new HtmlString("<img src= '/uploads/" . $record->id_back . "')>");
                        }),

                    Placeholder::make('proof_of_residence')
                        ->content(function ($record): HtmlString {
                            return new HtmlString("<img src= '/uploads/" . $record->proof_of_residence . "')>");
                        }),
                        
                    Forms\Components\Toggle::make('is_verified')
                        ->required()
                ])
            ]);
    }

    public static function table(Table $table): Table {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.email')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\ImageColumn::make('id_front')
                    ->width(50),
                Tables\Columns\ImageColumn::make('id_back')
                    ->width(50),
                Tables\Columns\ImageColumn::make('proof_of_residence')
                    ->width(50),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array {
        return [
            //
        ];
    }

    static function canCreate(): bool {
        return false;
    }

    public static function getPages(): array {
        return [
            'index' => Pages\ListVerifications::route('/'),
            'create' => Pages\CreateVerification::route('/create'),
            'view' => Pages\ViewVerification::route('/{record}'),
            'edit' => Pages\EditVerification::route('/{record}/edit'),
        ];
    }
}
