<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\Transaction;
use Filament\Resources\Resource;
use Illuminate\Database\Eloquent\Model;
use Filament\Forms\Components\ViewField;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\TransactionResource\Pages;
use ValentinMorice\FilamentJsonColumn\FilamentJsonColumn;
use App\Filament\Resources\TransactionResource\RelationManagers;

class TransactionResource extends Resource {
    protected static ?string $model = Transaction::class;

    protected static ?string $navigationIcon = 'heroicon-o-table-cells';

    protected static ?string $navigationGroup = 'User Management';

    protected static ?int $navigationSort = 4;

    public static function form(Form $form): Form {
        return $form
            ->schema([
                Forms\Components\Select::make('user_id')
                    ->relationship('user', 'email')
                    ->preload()
                    ->searchable()
                    ->native(false)
                    ->required(),
                Forms\Components\Select::make('coin_id')
                    ->relationship('coin')
                    ->preload()
                    ->searchable()
                    ->native(false)
                    ->required()
                    ->getOptionLabelFromRecordUsing(fn(Model $coin) => $coin->full_name),
                Forms\Components\TextInput::make('amount')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('network_fee')
                    ->required()
                    ->maxLength(255),
                Forms\Components\DateTimePicker::make('date')
                    ->required(),
                Forms\Components\Select::make('status')
                    ->native(false)
                    ->options([
                        'successful' => 'Successful',
                        'pending' => 'Pending',
                    ])
                    ->required(),
                ViewField::make('details')
                    ->view('filament.forms.components.details-input')->columnSpanFull(),
                Forms\Components\Select::make('type')
                    ->native(false)
                    ->options([
                        'swap' => 'Swap',
                        'send' => 'Send',
                        'receive' => 'Receive',
                    ])
                    ->required(),
                Forms\Components\Select::make('direction')
                    ->native(false)
                    ->options([
                        'credit' => 'Credit',
                        'debit' => 'Debit',
                    ])
                    ->required(),
                Forms\Components\TextInput::make('hash')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.email')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('coin.full_name')
                    ->searchable()
                    ->sortable(['name', 'symbol']),
                Tables\Columns\TextColumn::make('total_amount')
                    ->sortable(['amount'])
                    ->searchable(),
                Tables\Columns\TextColumn::make('full_network_fee')
                    ->label('Network Fee')
                    ->sortable(['network_fee'])
                    ->searchable(),
                Tables\Columns\TextColumn::make('date')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('status')
                    ->sortable()
                    ->badge()
                    ->color(fn(string $state): string => match ($state) {
                        'successful' => 'success',
                        'pending' => 'gray',
                    })
                    ->searchable(),
                Tables\Columns\TextColumn::make('type')
                    ->sortable()
                    ->badge()
                    ->color(fn(string $state): string => match ($state) {
                        'swap' => 'blue',
                        'send' => 'primary',
                        'receive' => 'gray',
                    })
                    ->searchable(),
                Tables\Columns\TextColumn::make('direction')
                    ->badge()
                    ->sortable()
                    ->color(fn(string $state): string => match ($state) {
                        'debit' => 'danger',
                        'credit' => 'success',
                    }),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array {
        return [
            //
        ];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function getPages(): array {
        return [
            'index' => Pages\ListTransactions::route('/'),
            'view' => Pages\ViewTransaction::route('/{record}'),
            'edit' => Pages\EditTransaction::route('/{record}/edit'),
        ];
    }
}
