<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Setting;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Tables\Columns\SettingsKeyColumn;
use App\Filament\Resources\SettingResource\Pages;
use Filament\Forms\Components\Section;
use Filament\Forms\Set;
use Illuminate\Database\Eloquent\Model;

class SettingResource extends Resource {
    protected static ?string $model = Setting::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    public static function form(Form $form): Form {
        return $form
            ->schema([
                Section::make()->schema([
                    Forms\Components\TextInput::make('value')
                        ->afterStateHydrated(fn(Setting $record, Set $set) => $set('text_value', $record->value))
                        ->label(fn(Model $record): string => convert_text($record->key))
                        ->default(setting('site_name'))
                        ->maxLength(255)
                        ->visible(false),


                    Forms\Components\TextInput::make('text_value')
                        ->afterStateHydrated(fn(Setting $record, Set $set) => $set('text_value', $record->value))
                        ->beforeStateDehydrated(fn(Setting $record, string $state, Set $set) => $set('value', $state))
                        ->label(fn(Model $record): string => convert_text($record->key))
                        ->default(setting('site_name'))
                        ->maxLength(255)
                        ->visible(fn(Model $record) => !is_image_link($record->value)),

                    Forms\Components\FileUpload::make('image_value')
                        ->image()
                        ->imageEditor()
                        ->label(fn(Model $record): string => convert_text($record->key))
                        ->visible(fn(Model $record) => is_image_link($record->value)),
                ]),
            ]);
    }

    public static function table(Table $table): Table {
        return $table
            ->columns([
                SettingsKeyColumn::make('key')
                    ->label('Information')
                    ->searchable(),
                Tables\Columns\TextColumn::make('value')
                    ->label('Details')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array {
        return [
            //
        ];
    }

    public static function canCreate(): bool {
        return false;
    }

    public static function getPages(): array {
        return [
            'index' => Pages\ListSettings::route('/'),
            'create' => Pages\CreateSetting::route('/create'),
            'view' => Pages\ViewSetting::route('/{record}'),
            'edit' => Pages\EditSetting::route('/{record}/edit'),
        ];
    }
}
