<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PreferenceResource\Pages;
use App\Filament\Resources\PreferenceResource\RelationManagers;
use App\Models\Preference;
use App\Models\Transaction;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PreferenceResource extends Resource {
    protected static ?string $model = Preference::class;

    protected static ?string $navigationIcon = 'heroicon-o-sparkles';

    protected static ?string $navigationGroup = 'User Management';

    protected static ?int $navigationSort = 5;

    public static function form(Form $form): Form {
        return $form
            ->schema([
                Forms\Components\Select::make('user_id')
                    ->relationship('user', 'email')
                    ->native(false)
                    ->required(),
                Forms\Components\Select::make('mode')
                    ->options([
                        'dark' => 'Dark Mode',
                        'light' => 'Light Mode'
                    ])
                    ->required()
                    ->default('dark'),
                Forms\Components\Toggle::make('show_balance')
                    ->required(),
                Forms\Components\Toggle::make('allow_emails')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.email')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\IconColumn::make('show_balance')
                    ->boolean(),
                Tables\Columns\IconColumn::make('allow_emails')
                    ->boolean(),
                Tables\Columns\TextColumn::make('mode')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array {
        return [
            //
        ];
    }

    public static function getPages(): array {
        return [
            'index' => Pages\ListPreferences::route('/'),
            'create' => Pages\CreatePreference::route('/create'),
            'view' => Pages\ViewPreference::route('/{record}'),
            'edit' => Pages\EditPreference::route('/{record}/edit'),
        ];
    }
}
